field = GF(9001)
pring.<x> = field[]

def one_step_naive(mat, k):
    # one step: put zeroes in first column of mat[k:, k:]
    piv = mat[k,k]
    assert piv != 0, f"non generic pivots {k}"

    for i in range(k+1, mat.nrows()):
        mat[i,k:] = piv * mat[i,k:] - mat[i,k] * mat[k,k:]

    return

def one_step(mat, k):
    # one step: put zeroes in first column of mat[k:, k:]
    g,u,v = xgcd(mat[k,k], mat[k+1,k])
    assert g == 1, f"non generic {k,k}"

    vec = u*mat[k,k:] + v*mat[k+1,k:]
    mat[k+1,k:] = mat[k,k] * mat[k+1,k:] - mat[k+1,k] * mat[k,k:]
    mat[k,k:] = vec
    for i in range(k+2, mat.nrows()):
        mat[i,k:] = mat[i,k:] - mat[i,k] * mat[k,k:]

    return


def matrix_size(mat):
    return m*m + sum(mat[i,j].degree() for j in range(mat.ncols()) for i in range(mat.nrows()) if mat[i,j] != 0)

m = 15
d = 4

mat = matrix.random(pring, m, m, degree=d)
mat1 = copy(mat)
sz0 = matrix_size(mat)
sz = sz0
sz1 = sz0

# save determinant for future checks:
det = mat.det()

print("      |  --------- NAIVE ---------  \t|   -------with GCD ---------   |")
print("step  |\tdeg\tsize\tratio\tratio0\t| deg\tsize\tratio\tratio0\t|")
print("------|---------------------------------|-------------------------------|")
print(f"input |\t{mat.degree()}\t{sz}\tnan\t1.00\t| {mat.degree()}\t{sz}\tnan\t1.00\t|")

for k in range(m-1):
    one_step_naive(mat1, k)
    #print(mat.degree_matrix())
    newsz1 = matrix_size(mat1)
    print(f"{k:<6}|\t{mat1.degree()}\t{newsz1}\t{RR(newsz1/sz1):.2e}\t{RR(newsz1/sz0):.2e}\t|", end="")
    sz1 = newsz1

    one_step(mat, k)
    #print(mat.degree_matrix())
    newsz = matrix_size(mat)
    print(f" {mat.degree()}\t{newsz}\t{RR(newsz/sz):.2e}\t{RR(newsz/sz0):.2e}\t|")
    sz = newsz

# check determinants:
det_test = mat[-1,-1]
# det_test1 = prod(mat[k,k] for k in range(m)) / prod(mat[k,k]**(m-1-k) for k in range(m-1))
# (negligeably) simpler:
det_test1 = mat[m-1,m-1] / prod(mat[k,k]**(m-2-k) for k in range(m-1))

print(f"dets are ok: {det == det_test} and {det == det_test1}")
