field = GF(97)
xring.<x> = field[]

xpts = [24, 31, 15, 32, 83, 27, 20, 59]
xpts = [field(pt) for pt in xpts]

ypts = [80, 73, 73, 35, 66, 46, 91, 64]
ypts = [field(pt) for pt in ypts]

L = xring.lagrange_polynomial(zip(xpts, ypts))
F = matrix([[1], [L], [L**2], [L**3]])
# note: L**2 and L**3 could be reduced to degree < 8,
# what matters is their class modulo the ideal of points

# case with uniform shift
P0 = F.minimal_interpolant_basis(xpts)

# case with "hermite" shift
H = F.minimal_interpolant_basis(xpts, shifts=[0,8,16,24])

# case with non uniform shift
s = [0,2,4,6]
P = F.minimal_interpolant_basis(xpts, shifts=s)

####################################
#  compute via divide and conquer  #
####################################

# call 1:
P1 = F.minimal_interpolant_basis(xpts[:4], shifts=s)

# update shift and compute residual
t = P1.row_degrees(shifts=s)
M1 = prod(x - xpt for xpt in xpts[:4])
G = (P1 * F) / M1  # seen as over fractions
G = G.change_ring(xring)  # make sure we are over polynomials

# call 2:
P2 = G.minimal_interpolant_basis(xpts[4:8], shifts=t)

PP = P2 * P1

# P and PP do not necessarily coincide!
print(P == PP)
# but they do represent the same solutions,
# and they both are s-reduced:
print(P.is_reduced(shifts=s) \
        and PP.is_reduced(shifts=s) \
        and PP.popov_form() == P.popov_form())
